<div id="scan_items_list">
</div>
<div class="container-fluid" id="barcode_reader_content">  
    <div class="row">
        <div class='col-12' style="padding:0px !important;">
            <a href="<?= site_url('xdocappshipment_list'); ?>">
                <img src='<?= site_url('assets/xdocapp/images/ic_arrow_white_black_24dp.png') ?>' class="back-arrow" alt='back-arrow'> 
            </a>
            <p class="back-arrow custom-p" style="    width: auto; 
               text-align: center; 
               margin: auto;"><?= lang('driverapp_scan_and_upload'); ?></p>
            <img src='<?= site_url('assets/xdocapp/images/header.png') ?>' style="height: 49px !important;" class='img-fluid1 header-bg'  alt='bg Truck'> 
        </div> 
    </div>
    <br>  
    <div class="row">
        <div class="col-12">
            <div style="display: none">
                <button class="button" id="startButton">Start</button>
                <button class="button" id="resetButton">Reset</button>
            </div>
            <div>
                <video id="video" style="width: 100%;height: 80vh;"></video>
            </div>

            <div id="sourceSelectPanel" style="display: none">
                <!-- <label for="sourceSelect">Change Camera</label> -->
                <select id="sourceSelect" class="form-control form-control-sm" style="max-width:400px">
                </select>
            </div>
            <div>
                <label>Result:</label>
                <pre>
                  <code id="result"></code>
                </pre> 
                <div>
                </div>
            </div> 
        </div>  
    </div>
</div>
<input type="hidden" value="<?= htmlentities(json_encode($scan_and_load_data)) ?>" id="scan_and_load_data" name="scan_and_load_data">
<link rel="stylesheet" href="<?= site_url('assets/xdocapp/css/scan_and_load_reader.css') ?>">  
<script type="text/javascript" src="<?= site_url('assets/xdocapp/js/barcode_reader/scan.min.js') ?>"></script>
<script type="text/javascript">
    window.addEventListener('load', function () {
        let selectedDeviceId;
        const codeReader = new ZXing.BrowserBarcodeReader();
        console.log('ZXing code reader initialized');

        // document.getElementById('resetButton').click();

        codeReader.getVideoInputDevices()
                .then((videoInputDevices) => {
                    const sourceSelect = document.getElementById('sourceSelect')
                    selectedDeviceId = videoInputDevices[0].deviceId
                    if (videoInputDevices.length > 1) {
                        selectedDeviceId = videoInputDevices[1].deviceId
                        videoInputDevices.forEach((element) => {
                            const sourceOption = document.createElement('option')
                            sourceOption.text = element.label
                            sourceOption.value = element.deviceId
                            sourceSelect.appendChild(sourceOption)
                        })

                        sourceSelect.onchange = () => {
                            selectedDeviceId = sourceSelect.value;
                            // alert(sourceSelect.value+"--source valie--");
                            camerareset();
                        }

                        const sourceSelectPanel = document.getElementById('sourceSelectPanel')
                        // sourceSelectPanel.style.display = 'block'
                    }

                    document.getElementById('startButton').addEventListener('click', () => {
                        codeReader.decodeOnceFromVideoDevice(selectedDeviceId, 'video').then((result) => {
                            document.getElementById('result').textContent = result.text;
                            getscan_and_items_list(result.text);

                        }).catch((err) => {
                            console.error(err);
                            codeReader.reset();
                            document.getElementById('result').textContent = err;
                            document.getElementById('resetButton').click();
                            document.getElementById('startButton').click();


                        })
                        console.log(`Started continous decode from camera with id ${selectedDeviceId}`)
                    })

                    document.getElementById('resetButton').addEventListener('click', () => {
                        document.getElementById('result').textContent = '';
                        codeReader.reset();
                        console.log('Reset.')
                    })

                    document.getElementById('startButton').click();

                })
                .catch((err) => {
                    console.error(err)
                })
    })


    function camerareset() {
        // alert('camera reset');
        document.getElementById('resetButton').click();
        document.getElementById('startButton').click();
    }

    function getscan_and_items_list(qr_code) { 
        // alert(qr_code.length);
        if (qr_code.length > 5) {
            var form = new FormData();
            form.append('scan_and_load_data', $('#scan_and_load_data').val());
            form.append("received_qr", qr_code);
            $.ajax({
                type: "POST",
                url: '<?= site_url('xdocappscan_and_load_items_list'); ?>',
                processData: false,
                data: form,
                contentType: false,
                cache: false,
                async: false,
                success: function (response) {
                    // alert('success block');
                    $('#scan_items_list').html(response);
                    $('#barcode_reader_content').html('');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    alert("Error Occurred.");
                }
            });
        } else {
            camerareset();
        }
    }
</script> 


<style>
    .table-bordered td, .table-bordered th {
        border: 1px solid #dee2e6;
    }
    .table td, .table th {
        padding: 0rem;
        vertical-align: middle;
        border-top: 1px solid #dee2e6;
    } 
    .table thead th {
        vertical-align: bottom;
        border-bottom: 2px solid #dee2e6;
        color: #fff;
        text-align: center;
        font-size: 0.85rem;
        padding: .4rem;
        background: #154da1;
    }
    table td {
        font-size: 0.7rem;
        padding-left: 14px;
    }

    table td {
        font-size: 0.8rem;
        text-transform: capitalize;
    }
    .scan_and_load_table tr td {
        text-align: center;
        padding: 0.3rem 0rem .3rem 0rem;
    }
    .custom_head{
        background-color: #0b2751;
        color: white;
    }
    .right_btn{
        float: right;
        margin-left: 6px;
    }
    .scan_and_load_table  tr td {
        text-align: center;
    }
    .plus_minus{
        font-size: 1.1rem;
    }
</style>
