function barChart(chartdata, Divtag) {
  maybeDisposeRoot(Divtag);
  var root = am5.Root.new(Divtag);
  root._logo.dispose();
  root.setThemes([am5themes_Animated.new(root)]);
  var chart = root.container.children.push(
    am5xy.XYChart.new(root, {
      panX: false,
      panY: false,
      wheelX: "none",
      wheelY: "none"
    })
  );
  chart.zoomOutButton.set("forceHidden", true);
  chart.get("colors").set("step", 2);

  var yRenderer = am5xy.AxisRendererY.new(root, { minGridDistance: 30 });
  yRenderer.grid.template.set("location", 1);

  var yAxis = chart.yAxes.push(
    am5xy.CategoryAxis.new(root, {
      maxDeviation: 0,
      categoryField: "laneName",
      renderer: yRenderer,
      tooltip: am5.Tooltip.new(root, {})
    })
  );

  yRenderer.labels.template.setAll({
    oversizedBehavior: "wrap",
    maxWidth: 100,
    textAlign: "center"
  });

  var xAxis = chart.xAxes.push(
    am5xy.ValueAxis.new(root, {
      maxDeviation: 0,
      min: 0,
      renderer: am5xy.AxisRendererX.new(root, {
        visible: true,
        strokeOpacity: 0.1
      })
    })
  );
  var series = chart.series.push(
    am5xy.ColumnSeries.new(root, {
      xAxis: xAxis,
      yAxis: yAxis,
      valueXField: "laneordercount",
      categoryYField: "laneName",
      tooltip: am5.Tooltip.new(root, {
        labelText: "{valueY} %"
      })
    })
  );

  var colors =  ["#13b4e5","#066481","#5e8e9d","#194c5c","#075770"];
  series.columns.template.adapters.add("fill", function(fill, target) {
    return colors[Math.floor(Math.random()*colors.length)];
  });

  yAxis.data.setAll(chartdata);
  series.data.setAll(chartdata);

  series.appear(1000);
  chart.appear(1000, 100);

}
