(function ($) {
  'use strict'
  jQuery(document).on('ready', function () {

    // Header Sticky
    $(window).on('scroll', function () {
      if ($(this).scrollTop() > 120) {
        $('.navbar-area').addClass('is-sticky')
      } else {
        $('.navbar-area').removeClass('is-sticky')
      }
    })

    // Mean Menu
    jQuery('.mean-menu').meanmenu({
      meanScreenWidth: '991'
    })

    $(document).on('click', '.pk_info', function () {
      var tail = $(this).data('tail')
      $('#pickup_info_slide' + tail).toggleClass('active')
    })
    $(document).on('click', '.dl_info', function () {
      var tail = $(this).data('tail')
      $('#delivery_info_slide' + tail).toggleClass('active')
    })
    $(document).on('click', '.sidebar-modal-close-btn', function () {
      $(this).parents('div.sidebar-modal').removeClass('active')
    })
    $(document).on('click', '.pk_card', function () {
      var tail = $(this).data('tail')
      $(this).toggleClass('active')
      $(this).find('.kg_col').toggle()
      $(this).find('.dt_col').toggle()
      $('.pk_sec' + tail).toggleClass('shadow-card')
      toggleIcon($(this), $('.pk_info_sec' + tail));
      if($(this).find('.pallete_icon').length) {
        toggleIcon($(this), $(this).find('.pallete_icon'));
      }
    })
    $(document).on('click', '.dl_card', function () {
      var tail = $(this).data('tail')
      $(this).toggleClass('active')
      $(this).find('.kg_col').toggle()
      $(this).find('.dt_col').toggle()
      $('.dl_sec' + tail).toggleClass('shadow-card');
      toggleIcon($(this), $('.dl_info_sec' + tail));
      if($(this).find('.pallete_icon').length) {
        toggleIcon($(this), $(this).find('.pallete_icon'));
      }
    })
  })

  var toggleIcon = function (currThis, actionBlk) {
    const fileName = fileNameUrl(actionBlk.find('img').attr('src'));
    var newColor =  currThis.hasClass('active') ? fileName.replace(/b/g, 'w') : fileName.replace(/w/g, 'b')
    actionBlk.find('img').attr('src', base_url + 'assets/driverappv3/img/' + newColor)
  }

  // Language Selector
  $('.language-selector .nav-item a').on('click', function () {
    var countryIcon = $(this).find('img').attr('src')
    $('.dropdown-toggle img').attr('src', countryIcon)
  })
}(jQuery))
