/* Cost Related Functions - Start */

// Gets Order Wise Cost details in a shift
function getCostDetailsByShiftId(shift_id){
	var table = $('#shift_rates').DataTable();
    table.destroy();
	$.ajax({
		url: baseurl+'shifts/getCostDetailsByShiftId',
		type: "post",
		data:{'shift_id':shift_id},
		dataType:'json',
		success: function(data){
			if(data.length > 0){
			   
			}else{
			   $("#shift_rates").DataTable({
                    data: data,
                    "bPaginate": false,
                    "paging": false,
                    "bLengthChange": true,
                    "bFilter": false,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                });
                table.clear().draw();
                var a = '<ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" style="left:0 !important;" role="menu">';
                var b = '<li><a id="bAdd" class="btn dt-add" onclick="addCostRow(this,' + shift_id + ');"><span class="glyphicon glyphicon-plus" > </span>Add Cost Details</a></li>';
                var c = '</ul></li></ul>';
                $('#shift_rates .dataTables_empty').html(a + b + c);
			}
		}
	});
}

// Displays a form to add cost details
function addCostRow(e, shift_id) {
	$.ajax({
		url: baseurl + 'shifts/addCostDetail',
		type: "POST",
		data: {
			'shift_id': shift_id
		},
		dataType: 'json',
		success: function (data) {
			if (data.shift_id != 0) {
				var tableId = $(e).closest('table').attr('id');
				var trOpen = '<tr id="editing">';
				var tds = '<form name="cost_form" class="cost_form" id="cost_form" method="POST" action="' + baseurl + 'Orderrevenues/savecost"><td><select form="newcost_form" placeholder="Select Order" class="form-control" name="cost_order_id" id="shift_orders" required></td><td><select name="costtype_role" id="costtype_role" class="form-control" onchange="getcostcodefromrole(this);" form="cost_form" ><option value="">Select</option> <option value="Carrier">Vendor</option><option value="Internal BU">Internal BU</option><option value="Overseas OL">Overseas OL</option></select></td><td style="min-width: 245px" class="measurement"><input onkeypress="return isNonSpecialCharCheck(event);" type="text" name="cost_codeid" parsley-trigger="change"  placeholder=" " class="form-control"  id="cost_codeid" value="" form="cost_form"><button class="btn btn-outline-secondary" type="button" data-placement="top" title="Find" data-toggle="modal" id="makeroletype" onclick="viewroletypelist(event)"><i class="icon tru-icon-find-new"></i></button></td><td style="min-width: 150px" ><input type="text" name="cost_totamount" onkeypress="return isNonSpecialCharCheck(event);" parsley-trigger="change"  placeholder=" " class="form-control decimal"  id="cost_totamount" value="" form="cost_form" readonly></td><td style="min-width: 150px" ><input type="text" name="cost_currency" parsley-trigger="change"  placeholder=" " class="form-control" onkeypress="return isNonSpecialCharCheck(event);" onkeypress="return isNonSpecialCharCheck(event);"  id="cost_currency" value="' + currency + '" form="cost_form" readonly></td></form>';
				var buttons = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left:0 !important;"><li><a id="bEdit" onclick="return savecost(this);"  type="button" class="btn btn-sm btn-default"><span class="glyphicon glyphicon-ok"> </span>Save</a></li>';
				var divClose = "</ul></li></ul></td>";
                var trClose = "</tr></tbody></table></td>";
				var html = trOpen + buttons + tds + divClose + trClose;
                rowAddNewBetween('shift_rates', e, html);
				
				// Loop Orders
				orders = data.orders;
                var order_opt = "<option value=''>Select Order</option>";
				$.each(orders, function (key, value) {
                    order_opt += "<option value='" + value + "'>" + value + "</option>";
                });
                order_opt += "</select>";
                $('#shift_orders').append(order_opt);
			}
		}
	});
}

// Get Role Type List
function viewroletypelist(type) {
    var table = $('#role_tab').DataTable();
    table.destroy();
    $("#view_roletype").modal('show');
    if (type == "Customer") {
        $("#view_roletype_title").html('Customer List');
    } else if (type = "Vendor") {
        $("#view_roletype_title").html('Vendor Type List');
    } else {
        $("#view_roletype_title").html('Role Type List');
    }
    $.ajax({
        url: baseurl + 'orders/viewroletypelist',
        type: "POST",
        data: {'type': type},
        dataType: 'JSON',
        success: function (data) {
            $("#role_tab").DataTable({
                data: data,
                "bPaginate": true,
                "paging": true,
                "bLengthChange": true,
                "bFilter": true,
                "bInfo": false,
                "bAutoWidth": true,
                "language": {
                    "lengthMenu": '<select class="form-control">' +
                            '<option value="10">10</option>' +
                            '<option value="20">20</option>' +
                            '<option value="30">30</option>' +
                            '<option value="40">40</option>' +
                            '<option value="50">50</option>' +
                            '<option value="-1">All</option>' +
                            '</select>'
                },
                dom: 'Blfrtip',
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    'print'
                ],
                "columns": [
                    {"data": "check"},
                    {"data": "code"},
                    {"data": "name"},
                    {"data": "email_id"},
                    {"data": "street"},
                    {"data": "city"},
                    {"data": "country"},
                    {"data": "company_code"},
                    {"data": "branch_code"},
                ],
            });
        }
    });
}

// Select the Role
function selectroleinlist() {
    var id = $('.roleselected-list').val();
    $.ajax({
        url: baseurl + 'orders/getshipperdetailsbyID',
        type: 'post',
        data: {id: id},
        dataType: 'json',
        success: function (data) {
            $('#view_roletype').modal('hide');
            var response = data.customer_details;
            var code = response[0].code;
            var name = response[0].name;
            $('#revenue_codeid').val(code);
            $('#revenue_name').val(name);
        }
    });
}

// Save Cost
function savecost(e) {
    var role = $('#costtype_role').val();
    var code = $('#cost_codeid').val();
    var name = $('#cost_name').val();
    if (role == "") {
        /*$('#costtype_role').focus();
         return false;*/
        gettoast('top-right', 'costtype_role', 'Please Select Role');
        return false;
    } else if (code == '') {
        /* $('#cost_codeid').focus();
         return false;*/
        gettoast('top-right', 'cost_codeid', 'Please enter a value in Code');
        return false;
    } else if (name == '') {
        /*$('#cost_codeid').focus();
         return false;*/
        gettoast('top-right', 'cost_name', 'Please enter a value in Name');
        return false;
    } else {
        var data = $("#cost_form").serializeArray();
        $.ajax({
            url: $("#cost_form").attr("action"),
            type: "POST",
            data: data,
            dataType: "JSON",
            success: function (data) {
            },
        }).done(function () {
            getcostdetailsbyorder();
            getallcostrevenues();
        });
        if ($('#cost_invoice_status').prop("checked") == true) {
            if ($('#cost_invoice_status').attr('disabled')) {
            } else {
                checkifstatusreadyornot();
            }
        }
        return false;
    }
}
/* Cost Related Functions - End */

function getShipOrdersDocuments(shift_id) {
    var table = $('#orders_doclist').DataTable();
    table.destroy();
    $.ajax({
        url: baseurl + 'shifts/orddocsdetails',
        type: "POST",
        data: {'shift_id': shift_id},
        dataType: 'json',
        success: function (data) {
            if (data.length > 0) {
                $("#orders_doclist").DataTable({
                    data: data,
                    "paging": false,
                    "bLengthChange": true,
                    "bFilter": false,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                    "columns": [
                        {"data": "action"},
                        {"data": "location"},
                        {"data": "type_name"},
                        {"data": "imgpath"},
                        {"data": "stop_id"},
                        {"data": "driver"},
                        {"data": "date"},
                    ],
                });
            } else {
                $("#orders_doclist").DataTable({
                    data: data,
                    "bPaginate": false,
                    "paging": false,
                    "bLengthChange": true,
                    "bFilter": false,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                });
                table.clear().draw();
                var a = '<ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" style="left:0 !important;" role="menu">';
                var b = '<li><a id="bAdd" class="btn dt-add" onclick="rowdocAdd(this,' + shift_id + ');"><span class="glyphicon glyphicon-plus" > </span>Add Doc</a></li>';
                var c = '</ul></li></ul>';
                $('#orders_doclist .dataTables_empty').html(a + b + c);
            }
        }
    });
}


// Add Document Form
function rowdocAdd(e, shift_id) {
    $.ajax({
        url: baseurl + 'shifts/addorderdoc',
        type: "POST",
        data: {'shift_id': shift_id},
        dataType: 'json',
        success: function (data) {
            if (data.booking_id != '0') {
                var booking_id = data.booking_id;
                var order_row_id = data.order_row_id;
                var trip_id = data.trip_id;
                var shift_id = data.shift_id;
                var company_code = data.company_code;
                var branch_code = data.branch_code;
                var tableId = $(e).closest('table').attr('id');
                var trOpen = "<tr id='editing'>";
                var tds = "<form name='newdoc_form' class='newdoc_form' id='newdoc_form' method='POST' action='" + baseurl + "admin/savenewpod' enctype='multipart/form-data'><td><select form='newdoc_form' placeholder='Select Order' class='form-control' name='order_id' id='shift_order' required></td><td colspan='2'><select form='newdoc_form' placeholder='Select Type' class='form-control' name='doc_type' id='doc_type' required><input form='newdoc_form' type='hidden' name='order_number' value='" + booking_id + "'><input form='newdoc_form' type='hidden' name='company_code' value='" + company_code + "'><input form='newdoc_form' type='hidden' name='branch_code' value='" + branch_code + "'><input form='newdoc_form' type='hidden' name='ship_id' value='" + shift_id + "'><input form='newdoc_form' type='hidden' name='trip_id' value='" + trip_id + "'></td><td colspan='2'><select form='newdoc_form' placeholder='Select Stop' class='form-control' name='stop_id' id='stop_id' required></td><td colspan='2'><input form='newdoc_form' type='file' placeholder='POD' id='updfile_name' class='form-control' name='file_name'></td></form>";
                var buttons = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left:0 !important;"><li><a id="bEdit" onclick="adddocdetails(event,'+shift_id+')"  type="button" class="btn btn-sm btn-default"><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bAcep" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowAcep(this);"><span class="glyphicon glyphicon-ok"> </span>Update</a></li>';
                var divClose = "</ul></li></ul></td>";
                var trClose = "</tr></tbody></table></td>";
                var html = trOpen + buttons + tds + divClose + trClose;
                rowAddNewBetween('orders_doclist', e, html);
                stops = data.stops;
                doc_type = data.document_types;
                orders = data.orders;
                var order_opt = "<option value=''>Select Order</option>";
                var opt = "<option value=''>Select Document Type</option>";
                var spot_opt = "<option value=''>Select Stop Id</option>";
                $.each(doc_type, function (key, value) {
                    opt += "<option value='" + value.id + "'>" + value.type_name + "</option>";
                });
                opt += "</select>";
                $('#doc_type').append(opt);
                $.each(stops, function (key, value) {
                    if(value != ""){
                        spot_opt += "<option value='" + value.id + "'>" + value.stopname + "</option>";
                    }
                });
                spot_opt += "</select>";
                $('#stop_id').append(spot_opt);
                $.each(orders, function (key, value) {
                    console.info(key+' '+value);
                    order_opt += "<option value='" + value + "'>" + value + "</option>";
                });
                order_opt += "</select>";
                $('#shift_order').append(order_opt);
            }
        }
    });
}

// Add Doc
function adddocdetails(evt, shift_id) {
    var file = document.getElementById("updfile_name");
    var doc_type = $("#doc_type").val();
    var chkfile = file.files.length;
    if (doc_type == "") {
        gettoast('top-right', 'doc_type', 'Please Select Document Type');
    } else if (chkfile == 0) {
        gettoast('top-right', 'updfile_name', 'Please Upload File');
    } else {
        var form_data = new FormData(document.getElementById("newdoc_form"));
        $.ajax({
            url: $("#newdoc_form").attr("action"),
            type: "POST",
            data: form_data,
            contentType: false,

            processData: false,
            success: function (response) {
                getShipOrdersDocuments(shift_id);
            },
        })
    }
}