$('.multiOrderToCarrierAssign').click(function(){
	$('.displayMultiOrderUpdateStatus').css('display','none');
	var totalSelectedOrders = $('input:checkbox.multiOrderToCarrierAssign:checked').length;
	if(parseInt(totalSelectedOrders) > 1)
	{
		$('.displayMultiOrderUpdateStatus').css('display','');
	}
});

$('.displayMultiOrderUpdateStatus').click(function(){
	var shiftIds = [];
	$("input:checkbox[id=multiOrderToCarrierAssign]:checked").each(function(){
		shiftIds.push($(this).val());
	});
	var baseUrl = $(this).attr('data-base-url');
	$.ajax({
		url: baseUrl+'visibility/getCarrierVehicleMultiAssignInfo',
		data: {'shift_id':shiftIds},
		type: "POST",
		beforeSend: function () {
			$(".buffer").show();
			$(".containerModal").modal("show");
			$(".containerModal").find(".modal-title").html("Assign Vehicle");
			$(".containerModal").find(".modal-body").html("<center><progress></center>");
		},
		success: function (data) {
			data = data.toString();
			if ($.trim(data) === '1') {
				$(".containerModal").find(".modal-body").css("text-align", "center");
				data = "<span style='font-size:16px;color:red;'> You can't assign driver to this shipment because this shipment has the legs</span>";
				$(".buffer").hide();
				$(".containerModal").find(".modal-body").html(data);
			} else {
				$(".buffer").hide();
				$(".containerModal").find(".modal-body").html(data);
			}

		}
	});
});

function assignMultiVehicleToShipmentStop(ele) {
	var activeElement = document.activeElement;
	var active_submit_btn = activeElement.value;
	var action = "just_save";
	if (active_submit_btn == "save_notify_customer") {
		var action = "notify";
	}
	var shipment_id = $('#assignMultiVehicleToShipmentStop').find("#shipment_id").val();
	var new_vehicle_id = $('#assignMultiVehicleToShipmentStop').find("#vehicle_id").val();
	var vehicle_id = $("#hiddenValues").data("veh");
	var register_number = $("#hiddenValues").data("reg");

	var old_driverid = $('#assignMultiVehicleToShipmentStop').find("#driveridhiden").val();
	var new_driverid = $('#assignMultiVehicleToShipmentStop').find("#driver_id").val();
	var notify_parties = $('#assignMultiVehicleToShipmentStop').find("#notify_parties").prop("checked");
	var schedule_date = $('#assignMultiVehicleToShipmentStop').find("#schedule_date").val();
	var carrier_id = $('#assignMultiVehicleToShipmentStop').find("#carrier_id").val();
	var selectedShipmentIds = shipment_id.split(',');
	if (notify_parties == true) {
		var action = "notify";
		$.each( selectedShipmentIds, function( index, shipmentId ) {
			notify_customer_consignee(action, shipmentId);
		});
	}
	if (schedule_date == "") {
		gettoast('top-right', 'city', 'Please Select Schedule Date');
		return false;
	}

	if (carrier_id == "" || carrier_id == "-select-") {
		gettoast('top-right', 'city', 'Please Select Carrier');
		return false;
	}
	if (new_vehicle_id == "-select-" || new_vehicle_id == "-Vehicles not found-") {
		gettoast('top-right', 'city', 'Please Select Vehicle');
		return false;
	}
	if (new_driverid == "") {
		gettoast('top-right', 'city', 'Please Select Driver');
		return false;
	}
	var baseURL = $('form#assignMultiVehicleToShipmentStop').attr('data-base-url');
	$.ajax({
		url: baseURL+'MultiOrderToCarrierAssign/checkTripActiveStatus',
		data: {"vehicle_id": new_vehicle_id, "shift_id": selectedShipmentIds, "action": action},
		async: false,
		type: "POST",
		dataType: "JSON",
        beforeSend: function () {
        	$(".assignVehicleToShipmentStopOverlay").show();
        },
        success: function (response) {
        	$(".assignVehicleToShipmentStopOverlay").hide();
        	if(response.status =="0")
        	{
        		multiOrderCarrierAssign(ele, new_vehicle_id, action, shipment_id);
        	}
        	else
        	{
        		alert(response.message)
				return false;
        	}
        }
    });
	return false;
}

function multiOrderCarrierAssign(ele, new_vehicle_id = '', action = '', shipment_id = '') {
    var dataa = $(ele).serializeArray();
    $.ajax({
        url: $('#assignMultiVehicleToShipmentStop').attr('action'),
        type: "POST",
        data: dataa,
        async: false,
        beforeSend: function () {
            $(".containerModal").find(".modal-body").html("<center><progress></center>");
        },
        success: function (data) {
            $(".containerModal").find(".modal-body").html('');
            if (data == 1) {
                $(".containerModal").find(".modal-body").html("<center style='color:green;font-weight:bold'>Successfully assigned!</center>");
                if (new_vehicle_id == "-select-") {
                    window.location.href = baseurl + 'visibility/shipment';
                }
                var selectedShipmentIds = shipment_id.split(',');
				$.each( selectedShipmentIds, function( index, shipmentId ) {
					notify_customer_consignee(action, shipmentId);
				});
            } else {
                $(".containerModal").find(".modal-body").html("<center style='color:green;font-weight:bold'>Vehicle un-assigned Successfully!</center>");
                window.location.href = baseurl + 'visibility/shipment';
            }
        }, error: function () {
            $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Vehicle assigning failed!</center>");
        }
    });
}