function viewPartyListForEnquiry(e, partyType) {
  e.preventDefault();
  var table = $('#partyListDataTable').DataTable();
  table.destroy();
  $('#masterTableBody').html("<tr><td colspan='13'><center><progress></progress></center></td></tr>");
  $("#viewPartyPopup").modal('show');
  $("#viewPartyPopupTitle").html(partyType + " Address");
  $('.selectparty').attr('onclick', "closeModal()");

  $.ajax({
    url: baseurl + 'rateenquiry/getpartymasterdata',
    type: "POST",
    data: {'partyType': partyType},
    dataType: "JSON",
    beforeSend: function () {
    },
    success: function (data) {
      $("#partyListDataTable").DataTable({
        data: data,
        'createdRow': function (row, data, dataIndex) {
          $(row).attr('id', "row-" + data.rowId)
        },
        "bPaginate": true,
        "paging": true,
        "bLengthChange": true,
        "bFilter": true,
        "bInfo": false,
        "bAutoWidth": true,
        "language": {
          "lengthMenu": '<select class="form-control">' +
            '<option value="10">10</option>' +
            '<option value="20">20</option>' +
            '<option value="30">30</option>' +
            '<option value="40">40</option>' +
            '<option value="50">50</option>' +
            '<option value="-1">All</option>' +
            '</select>'
        },
        dom: 'Blfrtip',
        buttons: [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          'print'
        ],
        "columns": [
          {"data": "checkBox"},
          {"data": "code"},
          {"data": "name"},
          {"data": "typeName"},
          {"data": "street"},
          {"data": "city"},
          {"data": "subDistrict"},
          {"data": "district"},
          {"data": "state"},
          {"data": "country"},
          {"data": "pincode"},
          {"data": "companyCode"},
          {"data": "branchCode"},
        ],
      });
    }
  });
}

function closeModal() {
  $("#viewPartyPopup").modal('hide');
}


function selectparty(id, partyType) {
  var code = $('#row-' + id).find("td:eq(1)").text().trim();
  var name = $('#row-' + id).find("td:eq(2)").text().trim();
  var street = $('#row-' + id).find("td:eq(4)").text().trim();
  var city = $('#row-' + id).find("td:eq(5)").text().trim();
  var subDistrict = $('#row-' + id).find("td:eq(6)").text().trim();
  var district = $('#row-' + id).find("td:eq(7)").text().trim();
  var state = $('#row-' + id).find("td:eq(8)").text().trim();
  var country = $('#row-' + id).find("td:eq(9)").text().trim();
  var pincode = $('#row-' + id).find("td:eq(10)").text().trim();
  if (partyType > 0) {
    $('#searchPickupRowId').val(id);
    $('#searchPickup').val(code);
    $('#pickupName').val(name);
    $('#pickupStreet').val(street);
    $('#pickupCity').val(city);
    $('#pickupState').val(state);
    $('#pickupSubDistrict').val(subDistrict);
    $('#pickupDistrict').val(district);
    $('#pickupCountry').val(country);
    $('#pickupPincode').val(pincode);
  } else {
    $('#searchDeliveryRowId').val(id);
    $('#searchDelivery').val(code);
    $('#consigneeName').val(name);
    $('#consigneeStreet').val(street);
    $('#consigneeCity').val(city);
    $('#consigneeState').val(state);
    $('#consigneeSubDistrict').val(subDistrict);
    $('#consigneeDistrict').val(district);
    $('#consigneeCountry').val(country);
    $('#consigneePincode').val(pincode);
  }
  var address = "";
  if (street != "") {
    street = "," + street;
  }
  if (city != "") {
    city = "," + city;
  }
  if (state != "") {
    state = "," + state;
  }
  if (subDistrict != "") {
    subDistrict = "," + subDistrict;
  }
  if (district != "") {
    district = "," + district;
  }
  if (country != "") {
    country = "," + country;
  }
  if (pincode != "") {
    pincode = "," + pincode;
  }
  var address = "<p>" + name + " " + street + " " + city + " " + state + " " + subDistrict + " " + district + " " + country + "," + pincode + "</p>";
  if (partyType > 0) {
    $('#shipperAddress').html(address);
    $('#shipperTextAddress').val(address);
  } else {
    $('#consigneeAddress').html(address);
    $('#consigneeTextAddress').val(address);
  }
}

$('#fromDate').datepicker({
  format: 'dd-mm-yyyy',
  autoclose: true,
}).on('changeDate', function (selected) {
  var minDate = new Date(selected.date.valueOf());
  $('#toDate').datepicker('setStartDate', minDate);
});
$('#toDate').datepicker({
  format: 'dd-mm-yyyy',
}).on('changeDate', function (selected) {
  var maxDate = new Date(selected.date.valueOf());
  $('#fromDate').datepicker('setEndDate', maxDate);
});

function closeAdvanceSearchTab() {
  $('#advanceSearchTab').removeClass('active in');
  $('#upArrow').css('display', 'none');
  $('#downArrow').css('display', 'block');
}

function hideDownArrow() {
  $('#downArrow').css('display', 'none');
  $('#upArrow').css('display', 'block');
}

function openRatesDetails(id, type) {
  if (type === 1) {
    var icon = "&nbsp;<i class='more-less fa-angle-up fa viewPriceIcon'></i>"
    $('#priceButton' + id).attr('onclick', 'openRatesDetails(' + id + ',0)');
    $('#priceButton' + id).html('Hide Prices ' + icon);
    $('#rateDetails' + id).css('display', 'block');
  } else {
    var icon = "&nbsp;<i class='more-less fa-angle-down fa viewPriceIcon'></i>"
    $('#priceButton' + id).attr('onclick', 'openRatesDetails(' + id + ',1)');
    $('#priceButton' + id).html('View Prices ' + icon);
    $('#rateDetails' + id).css('display', 'none');
  }
}

function viewAllRatesDetails(id) {
  var data = $("#ratesFrom" + id).serialize();
  $.ajax({
    url: baseurl + 'rateenquiry/viewAllratesDetails',
    data: data,
    type: "POST",
    beforeSend: function () {
      $(".ViewMoreDetailsTab").html("<center><progress></center>");
    },
    success: function (data) {
      $(".ViewMoreDetailsTab").html(data);
    }
  });
}

function closeAdvanceViewPopup() {
  $('.sidebars').css('display', 'none');
}

$('.pagination a').click(function () {
  var link = $(this).get(0).href;
  var form = $('#rateEnquirysearchForm');
  form.attr('action', link);
  form.submit();
  return false
});

function checkValidation() {
  var pickup = $('#searchPickup').val();
  if (pickup == "") {
    gettoast('top-right', 'searchPickup', 'Please select Pickup Address');
    return false;
  }
  var delivery = $('#searchDelivery').val();
  if (delivery == "") {
    gettoast('top-right', 'searchDelivery', 'Please select Delivery Address');
    return false;
  }
}

function gettoast(position, id, desp) {
  if (id != "") {
    if (!$('#' + id).hasClass('errorclass')) {
      $('#' + id).addClass('errorclass');
    }
  }
  init({
    fade_in: 800,
    fade_out: 800,
    position: position,
  });
  toast({
    type: 'custom',
    title: '<span style="color:#000000ab;">Warning Message</span>',
    description: '<span style="color:black;"><b>' + desp + '</b></span>',
    close_color: '#FF7F50',
    border_color: '#FF8C00',
    color: '#FFBF00',
    timeout: 900
  });
}

function displayPopupWithProfileData(tariffType, profileId, row) {
  $('.profileData').val("");
  var header = "Vendor Profile Data";
  if (tariffType > 0) {
    header = "Customer Profile Data";
  }
  $.ajax({
    url: baseurl + 'rateenquiry/getProfileDataById',
    data: {'tariffType': tariffType, 'profileId': profileId, 'row': row},
    type: "POST",
    beforeSend: function () {
      $(".viewProfileDataPopup").modal("show");
      $(".viewProfileDataPopup").find(".modal-title").html(header);
      $(".viewProfileDataPopup").find(".modal-body").html("<center><progress></center>");
    },
    success: function (data) {
      $(".viewProfileDataPopup").find(".modal-body").html(data);
    }
  });
}

function viewmodaleclose(id) {
    $('#' + id).modal('hide');
}


