function viewPartyListForEnquiry(e, partyType) {
  e.preventDefault();
  var table = $('#partyListDataTable').DataTable();
  table.destroy();
  $('#masterTableBody').html("<tr><td colspan='13'><center><progress></progress></center></td></tr>");
  $("#viewPartyPopup").modal('show');
  $("#viewPartyPopupTitle").html(partyType + " Address");
  $('.selectparty').attr('onclick', "closeModal()");
  $('.resetbtn').attr('onclick', "closeModal()");


  $.ajax({
    url: baseurl + 'rateenquiry/getpartymasterdata',
    type: "POST",
    data: {'partyType': partyType},
    dataType: "JSON",
    beforeSend: function () {
    },
    success: function (data) {
      $("#partyListDataTable").DataTable({
        data: data,
        'createdRow': function (row, data, dataIndex) {
          $(row).attr('id', "row-" + data.rowId)
        },
        "bPaginate": true,
        "paging": true,
        "bLengthChange": true,
        "bFilter": true,
        "bInfo": false,
        "bAutoWidth": true,
        "language": {
          "lengthMenu": '<select class="form-control">' +
            '<option value="10">10</option>' +
            '<option value="20">20</option>' +
            '<option value="30">30</option>' +
            '<option value="40">40</option>' +
            '<option value="50">50</option>' +
            '<option value="-1">All</option>' +
            '</select>'
        },
        dom: 'Blfrtip',
        buttons: [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          'print'
        ],
        "columns": [
          {"data": "checkBox"},
          {"data": "code"},
          {"data": "name"},
          {"data": "typeName"},
          {"data": "street"},
          {"data": "city"},
          {"data": "subDistrict"},
          {"data": "district"},
          {"data": "state"},
          {"data": "country"},
          {"data": "pincode"},
          {"data": "companyCode"},
          {"data": "branchCode"},
        ],
      });
    }
  });
}
function closeModal() {
  $("#viewPartyPopup").modal('hide');
}

function selectparty(id, partyType) {
  var code = $('#row-' + id).find("td:eq(1)").text().trim();
  var name = $('#row-' + id).find("td:eq(2)").text().trim();
  var street = $('#row-' + id).find("td:eq(4)").text().trim();
  var city = $('#row-' + id).find("td:eq(5)").text().trim();
  var subDistrict = $('#row-' + id).find("td:eq(6)").text().trim();
  var district = $('#row-' + id).find("td:eq(7)").text().trim();
  var state = $('#row-' + id).find("td:eq(8)").text().trim();
  var country = $('#row-' + id).find("td:eq(9)").text().trim();
  var pincode = $('#row-' + id).find("td:eq(10)").text().trim();
  if (partyType > 0) {
    $('#searchPickupRowId').val(id);
    $('#searchPickup').val(code);
    $('#pickupName').val(name);
    $('#pickupStreet').val(street);
    $('#pickupCity').val(city);
    $('#pickupState').val(state);
    $('#pickupSubDistrict').val(subDistrict);
    $('#pickupDistrict').val(district);
    $('#pickupCountry').val(country);
    $('#pickupPincode').val(pincode);
  } else {
    $('#searchDeliveryRowId').val(id);
    $('#searchDelivery').val(code);
    $('#consigneeName').val(name);
    $('#consigneeStreet').val(street);
    $('#consigneeCity').val(city);
    $('#consigneeState').val(state);
    $('#consigneeSubDistrict').val(subDistrict);
    $('#consigneeDistrict').val(district);
    $('#consigneeCountry').val(country);
    $('#consigneePincode').val(pincode);
  }
  var address = "";
  if (street != "") {
    street = "," + street;
  }
  if (city != "") {
    city = "," + city;
  }
  if (state != "") {
    state = "," + state;
  }
  if (subDistrict != "") {
    subDistrict = "," + subDistrict;
  }
  if (district != "") {
    district = "," + district;
  }
  if (country != "") {
    country = "," + country;
  }
  if (pincode != "") {
    pincode = "," + pincode;
  }
  var address = "<p>" + name + " " + street + " " + city + " " + state + " " + subDistrict + " " + district + " " + country + "," + pincode + "</p>";
  if (partyType > 0) {
    $('#shipperAddress').html(address);
    $('#shipperTextAddress').val(address);
  } else {
    $('#consigneeAddress').html(address);
    $('#consigneeTextAddress').val(address);
  }
}

function getvendorpflist(e, type) {
  e.preventDefault();
  var table = $('#vendorpftbl').DataTable();
  var value = $('#vendor_profile_id').val();
  if (type == 'search' && value == '') {
    gettoast('top-right', 'vendor_profile_id', 'Enter Vendor Profile ID');
    return false;
  }
  var company_code = $('#company_code').val();
  var branch_code = $('#branch_code').val();
  var senddata = {'company_code': company_code, 'branch_code': branch_code};
  if (type == "search") {
    senddata = {'company_code': company_code, 'branch_code': branch_code, 'term': value};
  }
  table.destroy();
  $("#view_vendorpf").modal('show');
  $("#view_vendorpf_title").html('Vendor Profiles list');
  $.ajax({
    url: baseurl + 'rateoffering/getvendorpflist',
    type: "POST",
    data: senddata,
    dataType: 'JSON',
    success: function (data) {
      $("#vendorpftbl").DataTable({
        data: data,
        "bPaginate": true,
        "paging": true,
        "bLengthChange": true,
        "bFilter": true,
        "bInfo": false,
        "bAutoWidth": true,
        "language": {
          "lengthMenu": '<select class="form-control">' +
            '<option value="10">10</option>' +
            '<option value="20">20</option>' +
            '<option value="30">30</option>' +
            '<option value="40">40</option>' +
            '<option value="50">50</option>' +
            '<option value="-1">All</option>' +
            '</select>'
        },
        dom: 'Blfrtip',
        buttons: [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          'print'
        ],
        "columns": [
          {"data": "check"},
          {"data": "vend_profile_id"},
          {"data": "name"},
          {"data": "company_code"},
          {"data": "branch_code"}
        ],
      });
    }
  });
}

function checkValidation() {
  var pickupCity = $('#pickupCity').val();
  var pickupCountry = $('#pickupCountry').val();
  var consigneeCity = $('#consigneeCity').val();
  var consigneeCountry = $('#consigneeCountry').val();
  if (pickupCity == "" && pickupCountry == "") {
    gettoast('top-right', 'pickupCity', 'Please select SourceCity or SourceCountry');
    return false;
  }
  if (consigneeCity == "" && consigneeCountry == "") {
    gettoast('top-right', 'consigneeCity', 'Please select DestinationCity or DestinationCountry');
    return false;
  }
}
$('.checkAll').on('click', function() {
  if (this.checked == true)
    $('.forcheckboxes').find('input[name="check_box"]').prop('checked', true);
  else
    $('.forcheckboxes').find('input[name="check_box"]').prop('checked', false);
});



