/*
Bootstable
 @description  Javascript library to make HMTL tables editable, using Bootstrap
 @version 1.1
 @autor Tito Hinostroza
*/
"use strict";
//Global variables
var params = null; //Parameters
var colsEdi = null;


var a = '<ul class="nav nav-tabs"><li class="dropdown"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu">' +
    '<li><a id="bEdit" type="button" class="btn btn-sm btn-default"  onclick="rowEdit(this);">' +
    '<span class="glyphicon glyphicon-pencil" > </span>' +
    'Edit' +
    '</a></li>' +
    '<li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);">' +
    '<span class="glyphicon glyphicon-trash" > </span>' +
    'Remove' +
    '</a></li>' +
    '<li><a id="bAcep" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowAcep(this);">' +
    '<span class="glyphicon glyphicon-ok" > </span>' +
    'Update' +
    '</a></li>' +
    '<li><a id="bCanc" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowCancel(this);">' +
    '<span class="glyphicon glyphicon-remove" > </span>' +
    'Cancel' +
    '</a></li>';



var b = '<li><a id="bAdd" type="button" class="btn btn-sm btn-default" onclick="rowAdd(this);">' +
    '<span class="glyphicon glyphicon-plus" > </span>' +
    'Add Cargo Details' +
    '</a></li>' +
    '<li><a id="innerpacking" type="button" class="btn btn-sm btn-default" onclick="tableAdd(this);">' +
    '<span class="fa fa-archive" > </span>' +
    'Add Inner Packing' +
    '</a></li>';


var d = '<li><a id="bAdd" type="button" class="btn btn-sm btn-default" onclick="rowAddParty(this);">' +
    '<span class="glyphicon glyphicon-plus" > </span>' +
    'Add' +
    '</a></li>';


var c = '</ul></li></ul>';


$.fn.SetEditable = function(options) {
    var defaults = {
        columnsEd: null, //Index to editable columns. If null all td editables. Ex.: "1,2,3,4,5"
        $addButton: null, //Jquery object of "Add" button
        onEdit: function() {}, //Called after edition
        onBeforeDelete: function() {}, //Called before deletion
        onDelete: function() {}, //Called after deletion
        onAdd: function() {} //Called when added a new row
    };
    params = $.extend(defaults, options);

    /*console.log($(this).attr('id'));*/

    if ($(this).hasClass("applyActionFilters")) {
        var newColHtml = a + b + c;
    } else if ($(this).attr("id") == 'involvedParties_details') {
        var newColHtml = a + d + c;
    } else {
        var newColHtml = a + c;
    }
    var colEdicHtml = '<td name="buttons">' + newColHtml + '</td>';

    this.find('thead tr').append('<th name="buttons"></th>'); //encabezado vacío
    this.find('tbody tr').append(colEdicHtml);
    var $tabedi = this; //Read reference to the current table, to resolve "this" here.
    //Process "addButton" parameter
    if (params.$addButton != null) {
        //Se proporcionó parámetro
        params.$addButton.click(function() {
            rowAddNew($tabedi.attr("id"));
        });
    }
    //Process "columnsEd" parameter
    if (params.columnsEd != null) {
        //Extract felds
        colsEdi = params.columnsEd.split(',');
    }
};

function IterarCamposEdit($cols, tarea) {
    //Itera por los campos editables de una fila
    var n = 0;
    $cols.each(function() {
        n++;
        if ($(this).attr('name') == 'buttons') return; //excluye columna de botones
        if (!EsEditable(n - 1)) return; //noe s campo editable
        tarea($(this));
    });

    function EsEditable(idx) {
        //Indica si la columna pasada está configurada para ser editable
        if (colsEdi == null) { //no se definió
            return true; //todas son editable
        } else { //hay filtro de campos
            //alert('verificando: ' + idx);
            for (var i = 0; i < colsEdi.length; i++) {
                if (idx == colsEdi[i]) return true;
            }
            return false; //no se encontró
        }
    }
}

function FijModoNormal(but) {
    $(but).parent().find('#bAcep').hide();
    $(but).parent().find('#bCanc').hide();
    $(but).parent().find('#bEdit').show();
    $(but).parent().find('#bElim').show();
    var $row = $(but).closest('tr'); //accede a la fila
    $row.attr('id', ''); //quita marca
}

function FijModoEdit(but) {
    $(but).parent().find('#bAcep').show();
    $(but).parent().find('#bCanc').show();
    $(but).parent().find('#bEdit').hide();
    $(but).parent().find('#bElim').hide();
    var $row = $(but).closest('tr'); //accede a la fila
    $row.attr('id', 'editing'); //indica que está en edición
}

function ModoEdicion($row) {
    if ($row.attr('id') == 'editing') {
        return true;
    } else {
        return false;
    }
}

function rowAcep(but) {
    //Acepta los cambios de la edición
    var $row = $(but).closest('tr'); //accede a la fila
    var $cols = $row.find('td'); //lee campos
    $(but).closest('td').find('#bAdd').show();
    $(but).closest('td').find('#innerpacking').show();
    $(but).closest('td').find('#bEdit').show();

    if (!ModoEdicion($row)) return; //Ya está en edición
    //Está en edición. Hay que finalizar la edición
    IterarCamposEdit($cols, function($td) { //itera por la columnas
        var cont = $td.find('input').val(); //lee contenido del input
        $td.html(cont); //fija contenido y elimina controles
    });
    FijModoNormal(but);
    params.onEdit($row);
}

function rowCancel(but) {
    //Rechaza los cambios de la edición
    var $row = $(but).closest('tr'); //accede a la fila
    var $cols = $row.find('td'); //lee campos

    $(but).closest('td').find('#bAdd').show();
    $(but).closest('td').find('#innerpacking').show();

    if (!ModoEdicion($row)) return; //Ya está en edición
    //Está en edición. Hay que finalizar la edición
    IterarCamposEdit($cols, function($td) { //itera por la columnas
        var cont = $td.find('div').html(); //lee contenido del div
        $td.html(cont); //fija contenido y elimina controles
    });
    FijModoNormal(but);
}

function rowEdit(but) { //Inicia la edición de una fila
    var $row = $(but).closest('tr'); //accede a la fila
    /*console.log($row);*/


    $(but).closest('td').find('#bAdd').hide();
    $(but).closest('td').find('#innerpacking').hide();
    $(but).closest('td').find('#bAcep').show();
    $(but).closest('td').find('#bEdit').show();

    var $cols = $row.find('td'); //lee campos
    if (ModoEdicion($row)) return; //Ya está en edición
    //Pone en modo de edición
    var i = 0;

    var tableId = $(but).closest('table').attr('id');
    var applyLogic = '0';

    if (tableId == 'cargo_details') {
        var applyLogic = '1';
    }


    if ($(but).closest('table').hasClass('dynamicTableAdd')) {
        var applyLogic = '1';
    }

    //console.log('edla');
    //console.log($(but).closest('table'));

    IterarCamposEdit($cols, function($td) { //itera por la columnas
        i++;

        var cont = $td.html(); //lee contenido
        var div = '<div style="display: none;">' + cont + '</div>'; //guarda contenido


        if (applyLogic == '1') {
         /*   console.log('td', $td);*/
            if ($($td).hasClass('measurement')) {
                if ($($td).hasClass('length')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>M</option><option>Cm</option><option>Inches</option></select></div>'

                } else if ($($td).hasClass('width')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>M</option><option>Cm</option><option>Inches</option></select></div>'

                } else if ($($td).hasClass('height')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>M</option><option>Cm</option><option>Inches</option></select></div>'

                } else if ($($td).hasClass('weight')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>Kg</option><option>Tons</option></select></div>'

                } else if ($($td).hasClass('volume')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>Cdm</option></select></div>'

                }

            } else {
                var input = '<input class="form-control input-sm"  value="' + cont + '">';
            }
        } else {
            var input = '<input class="form-control input-sm"  value="' + cont + '">';
        }





        $td.html(div + input); //fija contenido
    });
    FijModoEdit(but);
    measurementDrop();
}

function measurementDrop() {
    $('.dyntext').text("Kg");
    $(document).on('click', '.menuSelect li a.val', function() {
        var selectText = $(this).closest('ul li a.val').text();
        //console.log(selectText);
        // console.log($(this).closest('.dropdown .dyntext').text(selectText));
        $(this).closest('div').find('.dyntext').text(selectText);
    });
}

function rowEditInnerTablea(but,arr) { //Inicia la edición de una fila
    /*console.log(arr);*/
    $(but).closest('td').find('#bAdd').hide();
    $(but).closest('td').find('#innerpacking').show();
    $(but).closest('td').find('#bAcep').show();
    $(but).closest('td').find('#bEdit').show();
    var $row = $(but).closest('tr'); //accede a la fila
    /*console.log($row);*/
    var $cols = $row.find('td'); //lee campos
    if (ModoEdicion($row)) return; //Ya está en edición
    //Pone en modo de edición


    var i = 0;

    var tableId = $(but).closest('table').attr('id');
    var applyLogic = '0';

    if (tableId == 'cargo_details') {
        var applyLogic = '1';
    }


    /*console.log(applyLogic);*/


    IterarCamposEdit($cols, function($td) { //itera por la columnas
        i++;
        var cont = $td.html(); //lee contenido
        var div = '<div style="display: none;">' + cont + '</div>'; //guarda contenido
        if (applyLogic == '1') {
           /* console.log('td', $td);*/
            if ($($td).hasClass('measurement')) {
                if ($($td).hasClass('length')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>M</option><option>Cm</option><option>Inches</option></select></div>'

                } else if ($($td).hasClass('width')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>M</option><option>Cm</option><option>Inches</option></select></div>'

                } else if ($($td).hasClass('height')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>M</option><option>Cm</option><option>Inches</option></select></div>'

                } else if ($($td).hasClass('weight')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>Kg</option><option>Tons</option></select></div>'

                } else if ($($td).hasClass('volume')) {
                    var input = '<div class="input-group"><input type="text" class="form-control input-sm" aria-label="" value="' + cont + '"><select class="form-control "><option>Cdm</option></select></div>'

                }

            } else {
                var input = '<input class="form-control input-sm"  value="' + cont + '">';
            }
        } else {
            var input = '<input class="form-control input-sm"  value="' + cont + '">';
        }
        $td.html(div + input); //fija contenido
    });
    FijModoEdit(but);
}

function rowAcepInnerTable(but) {
    //Acepta los cambios de la edición

    $(but).closest('td').find('#bAdd').show();
    $(but).closest('td').find('#innerpacking').show();
    $(but).closest('td').find('#bAcep').hide();
    $(but).closest('td').find('#bEdit').show();


    var $row = $(but).closest('tr'); //accede a la fila
    var $cols = $row.find('td'); //lee campos
    if (!ModoEdicion($row)) return; //Ya está en edición
    //Está en edición. Hay que finalizar la edición
    IterarCamposEdit($cols, function($td) { //itera por la columnas
        var cont = $td.find('input').val(); //lee contenido del input
        $td.html(cont); //fija contenido y elimina controles
    });
    FijModoNormal(but);
    params.onEdit($row);
}

function rowCancelInnerTable(but) {
    //Rechaza los cambios de la edición
    var $row = $(but).closest('tr'); //accede a la fila
    var $cols = $row.find('td'); //lee campos
    if (!ModoEdicion($row)) return; //Ya está en edición
    //Está en edición. Hay que finalizar la edición
    IterarCamposEdit($cols, function($td) { //itera por la columnas
        var cont = $td.find('div').html(); //lee contenido del div
        $td.html(cont); //fija contenido y elimina controles
    });
    FijModoNormal(but);
}

function rowElimInnerTable(but) { //Elimina la fila actual
    var $row = $(but).closest('tr'); //accede a la fila
    //params.onBeforeDelete($row);
    $row.remove();
    //params.onDelete();
}


function rowElim(but) { //Elimina la fila actual
    var $row = $(but).closest('tr'); //accede a la fila
    params.onBeforeDelete($row);
    $row.remove();
    params.onDelete();
}

function rowAddNew(tabId) { //Agrega fila a la tabla indicada.
    var $tab_en_edic = $("#" + tabId); //Table to edit
    var $filas = $tab_en_edic.find('tbody tr');
    if ($filas.length == 0) {
        //No hay filas de datos. Hay que crearlas completas
        var $row = $tab_en_edic.find('thead tr'); //encabezado
        var $cols = $row.find('th'); //lee campos
        //construye html
        var htmlDat = '';
        $cols.each(function() {
            if ($(this).attr('name') == 'buttons') {
                //Es columna de botones
                htmlDat = htmlDat + colEdicHtml; //agrega botones
            } else {
                htmlDat = htmlDat + '<td></td>';
            }
        });
        $tab_en_edic.find('tbody').append('<tr>' + htmlDat + '</tr>');
    } else {
        //Hay otras filas, podemos clonar la última fila, para copiar los botones
        var $ultFila = $tab_en_edic.find('tr:last');
        $ultFila.clone().appendTo($ultFila.parent());
        $ultFila = $tab_en_edic.find('tr:last');
        var $cols = $ultFila.find('td'); //lee campos
        $cols.each(function() {
            if ($(this).attr('name') == 'buttons') {
                //Es columna de botones
            } else {
                $(this).html(''); //limpia contenido
            }
        });
    }
    params.onAdd();
}

function rowAddNewBetween(tabId, e, html) { //Agrega fila a la tabla indicada.
    var $tab_en_edic = $("#" + tabId); //Table to edit
    // var $filas = $tab_en_edic.find('tbody tr');

    //Hay otras filas, podemos clonar la última fila, para copiar los botones
    //  var $ultFila = $tab_en_edic.find('tr:last');

    var $ultFila = $(e).closest('tr').after(html);
   /* params.onAdd();*/
}


function TableToCSV(tabId, separator) { //Convierte tabla a CSV
    var datFil = '';
    var tmp = '';
    var $tab_en_edic = $("#" + tabId); //Table source
    $tab_en_edic.find('tbody tr').each(function() {
        //Termina la edición si es que existe
        if (ModoEdicion($(this))) {
            $(this).find('#bAcep').click(); //acepta edición
        }
        var $cols = $(this).find('td'); //lee campos
        datFil = '';
        $cols.each(function() {
            if ($(this).attr('name') == 'buttons') {
                //Es columna de botones
            } else {
                datFil = datFil + $(this).html() + separator;
            }
        });
        if (datFil != '') {
            datFil = datFil.substr(0, datFil.length - separator.length);
        }
        tmp = tmp + datFil + '\n';
    });
    return tmp;
}