var directionsService;
var directionsDisplay;
var trackerFrequency = 20000;
var start, end;
var defaultZoom = 10;
var googleMap, vehicle;

function InitializeGoogleMaps(plat, plng, dlat, dlng, clat, clng) {
  plat = +plat;
  plng = +plng;
  dlat = +dlat;
  dlng = +dlng;
  clat = +clat;
  clng = +clng;

  googleMap = new google.maps.Map(document.getElementById('map'), {
    center: { lat: plat, lng: plng },
    zoom: defaultZoom,
    styles: [
      { featureType: "all", stylers: [{ saturation: 0 }, { hue: "#e7ecf0" }] },
      { featureType: "road", stylers: [{ saturation: -70 }] },
      { featureType: "transit", stylers: [{ visibility: "off" }] },
      { featureType: "poi", stylers: [{ visibility: "off" }] },
      { featureType: "water", stylers: [{ visibility: "simplified" }, { saturation: -60 }] }
    ],
    mapTypeId: google.maps.MapTypeId.ROADMAP
  });

  directionsService = new google.maps.DirectionsService();
  directionsDisplay = new google.maps.DirectionsRenderer({ map: googleMap, suppressMarkers: true });

  const icon = siteurl + "assets/tracking/images/marker.png";
  const starticon = siteurl + "assets/images/icons/red_marker.png";
  const endicon = siteurl + "assets/images/icons/blue_marker.png";
  const vehiclePosition = new google.maps.LatLng(clat, clng);
  vehicle = new google.maps.Marker({
    position: vehiclePosition,
    map: googleMap,
    icon: icon
  });


  start = new google.maps.LatLng(plat, plng);
  const startMarker = new google.maps.Marker({
    position: start,
    map: googleMap,
    title: "Pickup Location",
    icon: {
      url: starticon,
      scaledSize: new google.maps.Size(40, 40)
    }
  });
  end = new google.maps.LatLng(dlat, dlng);
  const endMarker = new google.maps.Marker({
    position: end,
    map: googleMap,
    title: "Delivery Location",
    icon: {
      url: endicon,
      scaledSize: new google.maps.Size(40, 40)
    }
  });

  const request = {
    origin: start,
    destination: end,
    travelMode: google.maps.TravelMode.DRIVING
  };

  directionsService.route(request, function (response, status) {
    if (status === google.maps.DirectionsStatus.OK) {
      directionsDisplay.setDirections(response);

      const bounds = new google.maps.LatLngBounds();
      response.routes[0].legs.forEach(leg => {
        bounds.extend(leg.start_location);
        bounds.extend(leg.end_location);
      });
      bounds.extend(vehiclePosition);
      googleMap.fitBounds(bounds);

      google.maps.event.addListenerOnce(googleMap, 'idle', function () {
        const zoom = googleMap.getZoom();
        const minZoom = 6, maxZoom = 10;
        if (zoom < minZoom) {
          googleMap.setZoom(minZoom);
        } else if (zoom > maxZoom) {
          googleMap.setZoom(maxZoom);
        }
        defaultZoom = googleMap.getZoom();
      });
    } else {
      console.error("Directions request failed: " + status);
    }
  });
}

function queueFunction(plat, plng) {
  plat = +plat;
  plng = +plng;
  const latlng = new google.maps.LatLng(plat, plng);

  if (vehicle) {
    vehicle.setPosition(latlng);
  } else {
    vehicle = new google.maps.Marker({
      position: latlng,
      map: googleMap,
      icon: siteurl + "assets/tracking/images/marker.png"
    });
  }

  googleMap.setCenter(latlng);
  googleMap.setZoom(defaultZoom);
}

