<?php

require_once __DIR__ . '/../mysqli_prod/mysqli_prod_driver.php';

class CI_DB_mysqli_dev_driver extends CI_DB_mysqli_prod_driver {

	protected function _execute($sql)
	{
		static $httpRequestId = null;

		if (! $httpRequestId)
		{
			$httpRequestId = uniqid();
		}

		$traces = array_reverse(array_filter(debug_backtrace(), function($trace) { return strpos($trace['file'], $_SERVER['DOCUMENT_ROOT'] . '/application/') === 0; }));

		$log = '/*' . PHP_EOL . 'Start of SQL query for HTTP request ' . $httpRequestId . PHP_EOL;

		foreach ($traces as $trace)
		{
			$log .= str_replace($_SERVER['DOCUMENT_ROOT'], '', $trace['file']) . ':' . $trace['line'] . PHP_EOL;
		}

		$log .= '*/' . PHP_EOL;

		return parent::_execute($log . $sql . PHP_EOL . '/*' . PHP_EOL . 'End of SQL query for HTTP request ' . $httpRequestId . PHP_EOL . '*/' . PHP_EOL);
	}
}
