const base_url = $('#base_url').val()
const comment_error = $('#driverapp_please_enter_comment').val()
const select_picture_error = $('#driverapp_please_select_picture').val()
const invalid_input_error = $('#driverapp_please_enter_valid_input').val()
const missing_qty_error = $('#driverapp_please_enter_missing_quantity').val()
const signee_name_error = $('#driverapp_please_enter_signee_name').val()
const driver_name_error = $('#driverapp_please_enter_driver_name').val()
const mobile_number_error = $('#driverapp_please_enter_mobile_number').val()
const truck_reg_num_error = $('#driverapp_please_enter_truck_reg_num').val()
const spl_char_not_allow_error = $('#driverapp_special_characters_not_allowed').val()
const invalid_file_error = $('#driverapp_invalid_file').val()
const driverapp_attachment = $('#driverapp_attachment').val()
const next_label = $('#driverapp_next').val()
const confirm_close_label = $('#driverapp_confirm_close').val()
const driverapp_pickup_not_done_KN_message = $('#driverapp_pickup_not_done_KN_message').val()
let lang_status = []
let lang_status_h3 = []
let resStatusFlagArr = []
$(document).ready(function() {
    $("#fetchBtn").click(function(event) {
        event.preventDefault();
        var orderId = $("#tracking_number").val().trim();
        if (orderId !== "") {
            fetchApiData(orderId);
        } else {
            set_message('Please enter order ID.');
        }
    });

    function fetchApiData(orderId) {
        $.ajax({
            type: "GET",
            url: config.baseUrl + 'ELOGSTSRWB/fetchDataFromAPI',
            data: {
                orderId: orderId
            },
            cache: false,
            success: function(data) {
                console.log("API Response:", data);
                displayDataInSection(data);
            },
            error: function(xhr, textStatus, errorThrown) {
                console.error('There was a problem with the fetch operation:', errorThrown);
                alert('Failed to fetch data from API. Please try again.');
            }
        });
    }

    function displayDataInSection(data) {
        var response = JSON.parse(data);
        document.querySelector('.navbar-area.navbar-two').style.display = 'block';
        document.querySelector('.trip-block').style.display = 'block';
        if (response) {
            var orderId = response.orderId || '';
            var sourceCompany = response.sourceCompany || '';
            var plat = response.plat || '';
            var plng = response.plng || '';
            var earlyPickupDate = response.earlyPickupDate || '';
            var latePickupDate = response.latePickupDate || '';
            var destinationCompany = response.destinationCompany || '';
            var dlat = response.dlat || '';
            var dlng = response.dlng || '';
            var earlydropDate = response.earlydropDate || '';
            var latedropDate = response.latedropDate || '';
            var totalQuantity = response.totalQuantity || '';
            var totalWeightValue = response.totalWeightValue || '';
            var totalWeightUomCode = response.totalWeightUomCode || '';
            var totalVolumeValue = response.totalVolumeValue || '';
            var totalVolumeUomCode = response.totalVolumeUomCode || '';
            var statusCodes = response.statusCodes || [];
            var statusValues = response.statusValues || [];
            var pickupData = {
                "order_id": response.orderRowId,
                "trip_id": response.tripId,
                "shipment_id": response.shipmentId,
                "latitude": response.plat,
                "longitude": response.plng,
                "stop_type": "P",
                "organization_id": response.organizationId,
                "entity_value_id": response.entityValueId
            };
            var dropData = {
                "order_id": response.orderRowId,
                "trip_id": response.tripId,
                "shipment_id": response.shipmentId,
                "latitude": response.dlat,
                "longitude": response.dlng,
                "stop_type": "D",
                "organization_id": response.organizationId,
                "entity_value_id": response.entityValueId
            };

            var jsonPickData = JSON.stringify(pickupData);
            $('#pickup_data0').val(jsonPickData);
            var jsonDropData = JSON.stringify(dropData);
            $('#drop_data0').val(jsonDropData);

            document.querySelector('.pk_card .choose-text h3').textContent = orderId;
            document.querySelector('.pk_card .choose-text p').textContent = sourceCompany;
            document.querySelector('.pk_card .choose-text .kg_col').textContent = `${totalQuantity}-${totalWeightValue} ${totalWeightUomCode}-${totalVolumeValue} ${totalVolumeUomCode}`;
            document.querySelectorAll('.pk_card .choose-text .dt_col').textContent = earlyPickupDate || latePickupDate || '';
            document.querySelector('.dl_card .choose-text h3').textContent = orderId;
            document.querySelector('.dl_card .choose-text p').textContent = destinationCompany;
            document.querySelector('.dl_card .choose-text .kg_col').textContent = `${totalQuantity}-${totalWeightValue} ${totalWeightUomCode}-${totalVolumeValue} ${totalVolumeUomCode}`;
            document.querySelectorAll('.dl_card .choose-text .dt_col').textContent = earlydropDate || latedropDate || '';

            var listPickupIconsDiv = document.getElementById('pickupStatus');
            var htmlContent = '<ul class="list_stats">';
            if (statusCodes.includes('1491')) {
                htmlContent += `<li style="display: inline-block;"><button type="button"><span style="background:#56ccf2;"><img src="${config.arriveImg}" alt="gate_in" style="width:60%;height:60%;" /></span>${config.arriveText}</button></li>`;
            } else {
                htmlContent += `<li style="display: inline-block;"><button type="button" id="gatein_btn0"  data-status="PICKUP_GATE_IN" data-tail="0" curr-id="" data-next-id="" data-order-id="" data-trip-id="" class="gatein_btn0  act_btn"><span id="pgatein0"><img src="${config.arriveImg}" alt="gate_in" style="width:60%;height:60%;" /></span>${config.arriveText}</button></li>`;
            }
            if (statusCodes.includes('1048')) {
                htmlContent += `<li style="display: inline-block;"><button type="button"><span style="background:#56ccf2;"><img src="${config.pickupImg}" alt="pickup_icon" style="width:60%;height:60%;" /></span>${config.pickupText}</button></li>`;
            } else {
                htmlContent += `<li><input type="hidden" value="" id="crd_act_p_0"><button type="button" data-status="PICKUP" data-tail="0" curr-id="" data-next-id="" data-order-id="" data-trip-id="" class="pickup_btn0  act_btn"><span id="pickup0"><img src="${config.pickupImg}" alt="pickup_icon" style="width:60%;height:60%;" /></span>${config.pickupText}</button></li>`;
            }
            if (statusCodes.includes('3470')) {
                htmlContent += `<li style="display: inline-block;"><button type="button"><span style="background:#56ccf2;"><img src="${config.departedImg}" alt="gate_out" style="width:60%;height:60%;" /></span>${config.departedText}</button></li>`;
            } else {
                htmlContent += `<li style="display: inline-block;"><button type="button" data-status="PICKUP_GATE_OUT" data-tail="0" curr-id="" data-next-id="" data-order-id="" data-trip-id="" class="gateout_btn0  act_btn"><span id="pgateout0"><img src="${config.departedImg}" alt="gate_out" style="width:60%;height:60%;" /></span>${config.departedText}</button></li>`;
            }
            htmlContent += '</ul>';
            listPickupIconsDiv.innerHTML = htmlContent;
            var listDeliveryIconsDiv = document.getElementById('deliveryStatus');
            var htmlContent = '<ul class="list_stats">';

            if (statusCodes.includes('1748')) {
                htmlContent += `<li style="display: inline-block;"><button type="button"><span style="background:#56ccf2;"><img src="${config.arriveImg}" alt="gate_in" style="width:60%;height:60%;" /></span>${config.arriveText}</button></li>`;
            } else {
                htmlContent += `<li><button type="button" data-status="DELIVERY_GATE_IN" data-tail="0" curr-id="" data-next-id="" data-order-id="" data-trip-id="" class="d_gatein_btn0  act_btn"><span id="dgatein0"><img src="${config.arriveImg}" alt="gate_in" style="width:60%;height:60%;" /></span>${config.arriveText}</button></li>`;
            }
            if (statusCodes.includes('1750')) {
                htmlContent += `<li style="display: inline-block;"><button type="button"><span style="background:#56ccf2;"><img src="${config.deliveredImg}" alt="pickup_icon" style="width:60%;height:60%;" /></span>${config.pickupText}</button></li>`;
            } else {
                htmlContent += `<li style="display: inline-block;"><input type="hidden" value="" id="crd_act_d_0"><button type="button" data-status="DELIVERED" data-tail="0" curr-id="" data-next-id="" data-order-id="" data-trip-id="" class="delivery_btn0  act_btn"><span id="delivered0"><img src="${config.deliveredImg}" alt="delivery_icon" style="width:70%;height:70%;" /></span>${config.deliveredText}</button></li>`;
            }
            if (statusCodes.includes('1749')) {
                htmlContent += `<li style="display: inline-block;"><button type="button"><span style="background:#56ccf2;"><img src="${config.departedImg}" alt="gate_out" style="width:60%;height:60%;" /></span>${config.departedText}</button></li>`;
            } else {
                htmlContent += `<li style="display: inline-block;"><button type="button" data-status="DELIVERY_GATE_OUT" data-tail="0" curr-id="" data-next-id="" data-order-id="" data-trip-id="" class="d_gateout_btn0  act_btn"><span id="dgateout0"><img src="${config.departedImg}" alt="gate_out" style="width:60%;height:60%;" /></span>${config.departedText}</button></li>`;
            }
            htmlContent += '</ul>';
            listDeliveryIconsDiv.innerHTML = htmlContent;
        } else {
            console.log("No response data available");
        }
    }
});


function readURL (input, target_id) {
  if (input.files && input.files[0]) {
    var reader = new FileReader()
    reader.onload = function (e) {
      $('#' + target_id).attr('src', e.target.result)
    }
    reader.readAsDataURL(input.files[0]) // convert to base64 string
  }
}

'use strict'
$(document).on('keypress', '.onlyChars', function (event) {
    return onlyChars($(this), event);
});

$(document).on('blur', '.onlyChars, .onlyNumeric', function () {
    $(this).next('span.error').hide();
});

function onlyChars(select, event) {
    const regex = new RegExp('^[a-z A-Z]+$')
    return validateField(select, regex, invalid_input_error, event);
}

function onlyNumbers(select, event) {
    const regex = new RegExp('^[0-9]+$');
    return validateField(select, regex, spl_char_not_allow_error, event);
}

function validateField(select, regex, errorMessage, event){
    const key = String.fromCharCode(!event.charCode ? event.which : event.charCode)
    if (!regex.test(key)) {
        select.css('border-bottom', '1px solid tomato')
        select.next('span.error').html(errorMessage).show()
        event.preventDefault()
        return false
    } else {
        select.css('border-bottom', '1px solid #ced4da')
        select.next('span.error').html('')
        return true
    }
}

$(document).on('keypress', 'input[type="number"], .onlyNumeric', function (event) {
  return onlyNumbers($(this), event)
})

function setOrderStatus (stop_status, status_type, tail, selected) {
  var currentStepId = document.getElementById('nextIdInput').value;
  var currId = selected.getAttribute('curr-id');
  var nextId = selected.getAttribute('data-next-id');
  if (currId !== currentStepId) {
      set_message('Please complete the previous steps first.');
      return;
    }
  var status_stage = (status_type === 'T') ? 'IN_TRANSIT' : $(selected).attr('data-status');
  var data_order_id = $(selected).attr('data-order-id');
  var data_trip_id = $(selected).attr('data-trip-id');
  if (status_type !== 'T' && localStorage.getItem(tail + '_' + status_stage)) {
    return false
  }
  var form = new FormData();
  if (status_type === 'P') {
    form.append('pickup_data', $('#pickup_data' + tail).val());
    //comment = $('#comment' + tail).val()
  } else if (status_type === 'T') {
    status_type = 'P';
    status_stage = 'IN_TRANSIT';
    var latLng = $('#geoLocationLatLng').val();
    const urlSearchParams = new URLSearchParams(latLng);
    const latLngParams = Object.fromEntries(urlSearchParams.entries());
    var inTransData = JSON.parse($('#pickup_data' + tail).val());
    delete inTransData.latitude;
    delete inTransData.longitude;
    inTransData['latitude'] = latLngParams.lat;
    inTransData['longitude'] = latLngParams.lon;
    form.append('pickup_data', JSON.stringify(inTransData));
  } else if (status_type === 'D') {
    form.append('drop_data', $('#drop_data' + tail).val());
  }
  var pickup_POP_res = $('#pickup_POP_res' + tail).val();
  var delivery_POD_res = $('#delivery_POD_res' + tail).val();

  if (pickup_POP_res === 'err' || delivery_POD_res === 'err') {
    set_message('Picture/POD has some errors.');
    return false
  }
  if (status_stage.toUpperCase() === 'PICKUP') {
    status_stage = 'PICKUP_OK'
  }
  var tailNumber = $(selected).attr('data-tail');
  form.append('tail', tailNumber)
  form.append('status_stage', status_stage)
  form.append('status', stop_status)
  form.append('status_type', status_type)
  form.append('macadam_d3_data', pickup_POP_res)
  form.append('macadam_d3_POD_data', delivery_POD_res)
  var currentdate = new Date()
  var datetime = currentdate.getFullYear() + '-'
    + (currentdate.getMonth() + 1) + '-'
    + currentdate.getDate() + ' '
    + currentdate.getHours() + ':'
    + currentdate.getMinutes()
  form.append('status_manual_date', datetime)

var datetime = currentdate.getUTCFullYear() + '-'
    + (currentdate.getUTCMonth() + 1) + '-'
    + currentdate.getUTCDate() + ' '
    + currentdate.getUTCHours() + ':'
    + currentdate.getUTCMinutes();

form.append('status_manual_date_utc', datetime);
if (nextId) {
        form.append('nextId', nextId);
    }
  $('body').find('#preloader').show()

  return new Promise((resolve, reject) => {
    $.ajax({
      type: 'POST',
      url: base_url + '/updateOrderStatusDetailsDRV',
      processData: false,
      data: form,
      //async: false,
      contentType: false,
      cache: false,
      beforeSend: function () {
        showLoader()
        $(selected).attr('disabled', true)
        $('body .loading_roc').show()
        if (status_type === 'P') {
          $('#confirm_close').removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
        } else {
          $('.pod_error' + tail).html('')
          $('#d_confirm_close').removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
          $('#d_confirm_close_pod').removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
        }
      },
      success: function (response) {
        $('body').find('#preloader').hide();
        $(selected).attr('disabled', false);
        $('body .loading_roc').hide();
        
        var responseData = JSON.parse(response);
        if (responseData.status == 1) {
          var nextId = responseData.nextId;
          var spanColor = '#56ccf2';
          var statusCode = responseData.statusCode;
          var tail = responseData.tail;
          if (statusCode == "1491") {
            $('#pgatein' + tail).css('background', spanColor);
            $('.gatein_btn' + tail).find('button').prop('onclick', null).off('click');
          }else if (statusCode == "3470") {
            $('#pgateout' + tail).css('background', spanColor);
            $('.gateout_btn' + tail).find('button').prop('onclick', null).off('click');
          }else if (statusCode == "1748") {
            $('#dgatein' + tail).css('background', spanColor);
            $('.d_gatein_btn' + tail).find('button').prop('onclick', null).off('click');
          }else if (statusCode == "1749") {
            $('#dgateout' + tail).css('background', spanColor);
            $('.d_gateout_btn' + tail).find('button').prop('onclick', null).off('click');
          } else {
            set_message(responseData.data);
        }
        if (nextId) {
          document.getElementById('nextIdInput').value = nextId;
        }
        } else {
            set_message(responseData.data);
        }
      },
      error: function (jqXHR, textStatus, errorThrown) {
        var errorsResponse = JSON.parse(jqXHR.responseText);
        var errorMessages = '';
        $.each(errorsResponse.data, function (key, val){
          errorMessages +='<p>'+val+'</p>';
        });
        $(selected).prop('disabled', false)
        hideLoader()
        $('.modal1').css({ 'width': '310px' })
        set_message(errorMessages)
        if (status_type === 'P') {
          $('#confirm_close').removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false)
        } else {
          $('#d_confirm_close').removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false)
          $('#d_confirm_close_pod').removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false)
        }
        resolve({ error: errorThrown })
      },
      complete: function () {
        hideLoader()
        $('#pickup_POP_res').val('')
        $('#delivery_POD_res').val('')
        resolve()
      }
    })
  })
 
}

function from_check (form_id, confirm_btn_id, tail) {
  var r = 0
  $('form#' + form_id + tail).find('input[type!=hidden],textarea').each(function () {
    var ele = $(this)
    var val = ele.val().trim()
    if (ele.prop('required') && (val === '' || val === undefined)) {
      r++
    }
  })
  if (r) {
    $('#' + confirm_btn_id + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
  } else {
    $('#' + confirm_btn_id + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false)
  }
  return r;
}


function remove_active (selected_block) {
  $.each(selected_block, function () {
    if ($(this).hasClass('active')) {
      var s = fileNameUrl($(this).find('img').attr('src')).replace(/b/g, 'w')
      $(this).find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
      $(this).removeClass('active')
    }
  })
}

function add_active (select_b) {
  var s = fileNameUrl(select_b.find('img').attr('src')).replace(/w/g, 'b')
  select_b.find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
  select_b.addClass('active')
}

function allFormReset (tail) {
  $('form').each(function () {
    $(this)[0].reset()
    $(this).find('#fname' + tail).text(driverapp_attachment)
    $(this).find('#d_fname_pod' + tail).text(driverapp_attachment)
    $(this).find('#d_fname' + tail).text(driverapp_attachment)
    $(this).find('.imagePreview').hide()
    $(this).find('.imageAddCam').show()
  })
}

function clearAllFromsPK (tail) {
  $('#pickup_act_ico' + tail).hide()
  $('.pk_action_lables' + tail).show()
  $('#btn_com_pic_sec' + tail).hide()
  $('.pk_heading').find('span').html('')
  remove_active($('.action_btn_pk'))
  allFormReset(tail)
}

function sendAjaxRequest(form, successCallback) {
  $.ajax({
      type: 'POST',
      url: base_url + 'Drvlnkv1/documentUpload',
      data: form,
      processData: false,
      contentType: false,
      beforeSend: function() {
      },
      success: function(response) {
        var responseData = JSON.parse(response);
        if (responseData.status == 1) {
          var nextId = responseData.nextId;
          var spanColor = '#56ccf2';
          var docType = responseData.doctype;
          var tail = responseData.tail;
          if (docType == "POP") {
            $('#btn_com_pic_sec'+ tail).hide();
            $('#pickup'+ tail).css('background', spanColor);
            $('.pickup_btn').find('button').prop('onclick', null).off('click');
          } else if (docType == "POD") {
            $('#d_btn_com_pic_sec'+ tail).hide();
            $('#delivered'+ tail).css('background', spanColor);
            $('.delivery_btn').find('button').prop('onclick', null).off('click');
          }else {
            console.log("Unknown document type:", docType);
        }
        if (nextId) {
          document.getElementById('nextIdInput').value = nextId;
        }
        
      }
      else if (responseData.status == 2 && responseData.statusCode == "1048" ) {
        var nextId = responseData.nextId;
        var tail = responseData.tail;
        var spanColor = '#56ccf2';
        $('#btn_com_pic_sec' + tail).css('display', 'none');
        $('#pickup'+ tail).css('background', spanColor);
        $('.pickup_btn').find('button').prop('onclick', null).off('click');
        if (nextId) {
          document.getElementById('nextIdInput').value = nextId;
        }
      }
       else {
        alert('Error: ' + responseData.message);
    }
          successCallback(response);
      },
      error: function(xhr, status, error) {
          console.error('AJAX Error:', error);
          alert('An error occurred while processing your request. Please try again later.');
      },
      complete: function() {
          // Perform cleanup tasks if needed
      }
  });
}
function setDeliveryData(stop_status, status_type, tail, selected) {
  var currentStepId = document.getElementById('nextIdInput').value;
  var currId = selected.getAttribute('curr-id');
  var nextId = selected.getAttribute('data-next-id');
  if (currId !== currentStepId) {
    set_message('Please complete the previous steps first.');
    return;
}
  var form = new FormData();
  form.append('drop_data', $('#drop_data' + tail).val());
  var status_stage = $(selected).attr('data-status');
  var tailNumber = $(selected).attr('data-tail');
  var currentdate = new Date();
  var datetime = currentdate.getUTCFullYear() + '-'
  + (currentdate.getUTCMonth() + 1) + '-'
  + currentdate.getUTCDate() + ' '
  + currentdate.getUTCHours() + ':'
  + currentdate.getUTCMinutes();
  form.append('status_manual_date_utc', datetime);
  $('#d_btn_com_pic_sec' + tail).show();
    // Handle file input change event for attachment
    $('#d_button'+ tail).off('click').on('click', function() {
        $('#d_picture_upload' + tail).click();
    });

  // Handle file input change event for validation
  $('#d_picture_upload' + tail).off('change').on('change', function() {
      var fileInput = $(this);
      var filePath = fileInput.val();
      var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.gif|\.pdf)$/i;

      // Validate file extension
      if (!allowedExtensions.exec(filePath)) {
          alert('Invalid file type! Please upload a file with the following extensions: .jpg, .jpeg, .png, .gif, .pdf');
          fileInput.val('');
          $('#picture_base64' + tail).val('');
          return false;
      }
      
      var fileName = filePath.replace(/^.*[\\\/]/, '');
      $('#d_selected_file_name' + tail).text(fileName);
  });
    // Handle camera file input change event
    $('#d_imgIco' + tail).off('click').on('click', function() {
        $('#d_picture_camera' + tail).click();
    });
$('#d_picture_camera' + tail).off('change').on('change', function () {
  var file = $(this).prop('files')[0];
  if (file) {
      var reader = new FileReader();
      reader.onload = function (e) {
          var img = new Image();
          img.src = e.target.result;
          img.onload = function () {
              var canvas = document.createElement('canvas');
              var ctx = canvas.getContext('2d');
              var maxWidth = 800; // Max width for the image
              var maxHeight = 600; // Max height for the image
              var width = img.width;
              var height = img.height;

              // Calculate the new dimensions while keeping the aspect ratio
              if (width > height) {
                  if (width > maxWidth) {
                      height *= maxWidth / width;
                      width = maxWidth;
                  }
              } else {
                  if (height > maxHeight) {
                      width *= maxHeight / height;
                      height = maxHeight;
                  }
              }

              // Set the canvas dimensions to the new dimensions
              canvas.width = width;
              canvas.height = height;

              // Draw the image on the canvas
              ctx.drawImage(img, 0, 0, width, height);

              // Initialize compression quality and size check
              var quality = 0.9; // Start with high quality
              var compressedDataUrl;
              do {
                  // Convert the canvas to a data URL with the current quality
                  compressedDataUrl = canvas.toDataURL('image/jpeg', quality);
                  quality -= 0.1; // Decrease quality for next iteration
              } while (compressedDataUrl.length > 2 * 1024 * 1024 && quality > 0); // Check if size is within limit

              if (compressedDataUrl.length > 2 * 1024 * 1024) {
                  alert('The image cannot be compressed to below 2MB. Please select a smaller image.');
                  return;
              }

              // Display the compressed image preview
              $('#d_imagePreview' + tail).html('<img src="' + compressedDataUrl + '" style="object-fit: contain" />').show();

              // Convert the data URL to a Blob
              var byteString = atob(compressedDataUrl.split(',')[1]);
              var mimeString = compressedDataUrl.split(',')[0].split(':')[1].split(';')[0];
              var ab = new ArrayBuffer(byteString.length);
              var ia = new Uint8Array(ab);
              for (var i = 0; i < byteString.length; i++) {
                  ia[i] = byteString.charCodeAt(i);
              }
              var compressedBlob = new Blob([ab], { type: mimeString });

              // Update the form data with the compressed image
              var dataTransfer = new DataTransfer();
              dataTransfer.items.add(new File([compressedBlob], file.name, { type: mimeString }));
              $('#d_picture_camera' + tail)[0].files = dataTransfer.files;
              //var file = dataTransfer.files;
          };
      };
      reader.readAsDataURL(file);
  }
});

$('#d_confirm_close'+ tail).prop('disabled', false);
  // Handle the confirm & close button click event
  $('#d_confirm_close'+ tail).off('click').on('click', function() {
      var file = $('#d_picture_upload' + tail).prop('files')[0] || $('#d_picture_camera' + tail).prop('files')[0];

      if (file) {
        // Check file size
        if (file.size > 2 * 1024 * 1024) { // 2MB limit
            alert('File size exceeds the limit of 2MB.');
            return;
        }
        form.append('file', file);
    }
      form.append('status_stage', status_stage)
      form.append('file', file);
      form.append('stop_status', stop_status);
      form.append('status_type', status_type);
      form.append('tail', tailNumber);
      if (nextId) {
        form.append('nextId', nextId);
    }
      sendAjaxRequest(form, function(response) {
          // Handle success response
          var responseData = JSON.parse(response);
          if (responseData.status == 1) {
            var nextId = responseData.nextId;
            var spanColor = '#56ccf2';
            var docType = responseData.doctype;
            var tail = responseData.tail;
            if (docType == 'POP') {
              $('#btn_com_pic_sec'+ tail).hide();
              $('#pickup'+ tail).css('background', spanColor);
              $('.pickup_btn').find('button').prop('onclick', null).off('click');
            } else if (docType == 'POD') {
              $('#d_btn_com_pic_sec'+ tail).css('display', 'none');
              $('#delivered'+ tail).css('background', spanColor);
              $('.delivery_btn').find('button').prop('onclick', null).off('click');
            }else {
              console.log("Unknown document type:", docType);
          }
          if (nextId) {
            document.getElementById('nextIdInput').value = nextId;
          }
          } 
          else {
              // Operation failed, display error message
              alert('Error: ' + responseData.message);
          }
      });
  });
  
}

function setPickupData(stop_status, status_type, tail, selected) {
 var currentStepId = document.getElementById('nextIdInput').value;
  var currId = selected.getAttribute('curr-id');
  var nextId = selected.getAttribute('data-next-id');
  if (currId !== currentStepId) {
      set_message('Please complete the previous steps first.');
      return;
  }
  var form = new FormData();
  form.append('pickup_data', $('#pickup_data' + tail).val());
  var status_stage = $(selected).attr('data-status');
  var tailNumber = $(selected).attr('data-tail');
  var currentdate = new Date();
  var datetime = currentdate.getUTCFullYear() + '-'
    + (currentdate.getUTCMonth() + 1) + '-'
    + currentdate.getUTCDate() + ' '
    + currentdate.getUTCHours() + ':'
    + currentdate.getUTCMinutes();

  // Show the pickDone-hideshow div
  $('#btn_com_pic_sec' + tail).show();
// Handle file input change event for attachment
$('#button'+ tail).off('click').on('click', function() {
  $('#picture' + tail).click();
});
  // Handle file input change event for validation
  $('#picture' + tail).off('change').on('change', function() {
      var fileInput = $(this);
      var filePath = fileInput.val();
      var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.gif|\.pdf)$/i;
      // Validate file extension
      if (!allowedExtensions.exec(filePath)) {
          alert('Invalid file type! Please upload a file with the following extensions: .jpg, .jpeg, .png, .gif, .pdf');
          fileInput.val('');
          $('#picture_base64' + tail).val('');
          return false;
      }
      var fileName = filePath.replace(/^.*[\\\/]/, '');
      $('#selected_file_name' + tail).text(fileName);
  });
   // Handle camera file input change event
   $('#imgIco' + tail).off('click').on('click', function() {
    $('#picture_camera' + tail).click();
});
  $('#picture_camera' + tail).off('change').on('change', function () {
    var file = $(this).prop('files')[0];
    if (file) {
        var reader = new FileReader();
        reader.onload = function (e) {
            // Display the captured image preview
            $('#imagePreview' + tail).html('<img src="' + e.target.result + '" style="object-fit: contain" />').show();
        };
        reader.readAsDataURL(file);
    }
});

  // Handle the confirm & close button click event
  $('#confirm_close' + tail).on('click', function() {
      var file = $('#picture' + tail).prop('files')[0] || $('#picture_camera' + tail).prop('files')[0];
      if (file) {
        // Check file size
        if (file.size > 2 * 1024 * 1024) { // 2MB limit
            alert('File size exceeds the limit of 2MB.');
            return;
        }
        form.append('file', file);
    }
      form.append('status_stage', status_stage);
      // form.append('file', file);
      form.append('stop_status', stop_status);
      form.append('status_type', status_type);
      form.append('status_manual_date_utc', datetime);
      form.append('tail', tailNumber);
      if (nextId) {
        form.append('nextId', nextId);
    }

      // Send AJAX request to controller
      sendAjaxRequest(form, function(response) {
          // Handle success response
          var responseData = JSON.parse(response);
          if (responseData.status == 1) {
            var nextId = responseData.nextId;
            var spanColor = '#56ccf2';
            var docType = responseData.doctype;
            var tail = responseData.tail;
            if (docType == 'POP') {
              $('#btn_com_pic_sec'+ tail).hide();
              $('#pickup'+ tail).css('background', spanColor);
              $('.pickup_btn').find('button').prop('onclick', null).off('click');
            } else if (docType == 'POD') {
              $('#d_btn_com_pic_sec'+ tail).hide();
              $('#delivered'+ tail).css('background', spanColor);
              $('.delivery_btn').find('button').prop('onclick', null).off('click');
            }else {
              console.log("Unknown document type:", docType);
          }
          if (nextId) {
            document.getElementById('nextIdInput').value = nextId;
          }
          } else if (responseData.status == 2 && responseData.statusCode == "1048" ) {
            var nextId = responseData.nextId;
            var tail = responseData.tail;
            var spanColor = '#56ccf2';
            $('#btn_com_pic_sec' + tail).css('display', 'none');
            $('#pickup'+ tail).css('background', spanColor);
            $('.pickup_btn').find('button').prop('onclick', null).off('click');
            if (nextId) {
              document.getElementById('nextIdInput').value = nextId;
            }
          }else {
              // Operation failed, display error message
              alert('Error: ' + responseData.message);
          }
      });
  });
 
}



function clearAllFromsDL (tail) {
  $('#delivery_act_ico' + tail).hide()
  $('.dl_action_lables' + tail).show()
  $('#d_btn_com_pic_sec' + tail).hide()
  $('#btn_com_pic_sec' + tail).hide()
  $('#deliveryModal_pod' + tail).hide()
  $('.dl_heading').show().find('span').html('')
  remove_active($('.action_btn_dl'))
  allFormReset(tail)
}


function showLoader () {
  $('body .loading_roc').css('display', '')
}

function hideLoader () {
  $('body .loading_roc').css('display', 'none')
}

$(function () {
  $(document).on('cut copy paste', 'input', function (e) {
    e.preventDefault()
  })
})

window.onbeforeunload = function () {
  document.getElementById('preloader').style.display = 'block'
}
document.onreadystatechange = function () {
  var state = document.readyState
  if (state === 'interactive') {
    // document.getElementById('preloader').style.display="block";
  } else if (state === 'complete') {
    setTimeout(function () {
      document.getElementById('interactive')
      //document.getElementById('preloader').style.display = 'none'
    }, 1)
  }
}
var shareLocationCountShow = function (){
  const allowedDriverCountriesToShare = JSON.parse($('#secure_link_in_trans_share_location_allowed_countries').val());
  const companyCode = $('#company_code').val();
  if(jQuery.inArray(companyCode, allowedDriverCountriesToShare) === -1){
      return false;
  }
  var _shareLocationEligibleOrders = $('#shareLocationEligibleOrders');
  var shareLocationEligibleOrders = JSON.parse(_shareLocationEligibleOrders.val());
  var s = '';
  if (shareLocationEligibleOrders.length < 1) {
    const shareLocBtnEle = $('#shareLocationBtn')
    shareLocBtnEle.attr('disabled', true)
    shareLocBtnEle.removeClass('shadow-card')
    s = fileNameUrl(shareLocBtnEle.find('img').attr('src')).replace(/w/g, 'b')
    shareLocBtnEle.find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
  } else {
    const shareLocBtnEle = $('#shareLocationBtn')
    shareLocBtnEle.attr('disabled', false)
    shareLocBtnEle.addClass('shadow-card')
    s = fileNameUrl(shareLocBtnEle.find('img').attr('src')).replace(/b/g, 'w')
    shareLocBtnEle.find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
  }

  var locationSharedCount = $('#share_location_count').val()
  if(locationSharedCount > 0 ){
    $('#shareLocationBtn').addClass('complete').addClass('delivery_share_location_count');
  }
  if(locationSharedCount > 9) {
    $('.share-location-count-label').css('left', '35px');
  }
  const locationSharedCountEle = $('#locationSharedCount')
  locationSharedCountEle.html(locationSharedCount)
  locationSharedCountEle.css('display', locationSharedCount > 0 ? 'block' : 'none');
}

var shareLocationEligibleBtn = function(orderID, Action = 'PUSH'){
  const allowedDriverCountriesToShare = JSON.parse($('#secure_link_in_trans_share_location_allowed_countries').val());
  const companyCode = $('#company_code').val();
  if(jQuery.inArray(companyCode, allowedDriverCountriesToShare) === -1){
      return false;
  }
  // pickup phase done -> enable share location
  var _shareLocationEligibleOrders = $('#shareLocationEligibleOrders');
  var shareLocationEligibleOrders = JSON.parse(_shareLocationEligibleOrders.val());

  if (Action === 'PUSH') {
    shareLocationEligibleOrders.push(orderID)
  }
  if (Action === 'POP') {
    orderID = orderID.replace(/d\_/i, "");
    const index = shareLocationEligibleOrders.indexOf(orderID);
    if (index > -1) {
      shareLocationEligibleOrders.splice(index, 1);
    }
  }

  $('#shareLocationBtnLabelCount').html(shareLocationEligibleOrders.length);
  _shareLocationEligibleOrders.val(JSON.stringify(shareLocationEligibleOrders));
}

$.ajaxSetup({
    beforeSend: showLoader,
    complete: hideLoader
});
function set_message(user_mesage, button_msg = 'OK') {
    $('#user_message').html(user_mesage);
    $('#msg_1').html('Message');
    $('#msg_2').html(button_msg);

    if (user_mesage.length > 2) {
        document.getElementById('alert_modal').style.display = 'block';
    } else {
        document.getElementById('alert_modal').style.display = 'none';
    }
    if (button_msg !== 'OK') {
        $('#msg_2').click(() => {
            window.location.reload();
        })
    }
}
function change_language() {
    var final_lang = $('#final_lang').val()
    if (final_lang.length < 3) {
        set_message('Please select valid language')
        return false
    }
    var form = new FormData()
    form.append('language', final_lang)
    $.ajax({
        type: 'POST',
        url: base_url + 'driversite_language2',
        processData: false,
        data: form,
        contentType: false,
        cache: false,
        beforeSend: function() {
            $('body .loading_roc').show()
            showLoader()
        },
        success: function(response) {
            var res = JSON.parse(response)
            if (parseInt(res.status) === 1) {
                window.location.reload()
            } else {
                set_message(res.response)
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            hideLoader()
            set_message('Error Occurred.')
        }
    })
}
