<!doctype html>
<html>

<head>
    <title>SVKONEKT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php $assets_url = base_url('assets/scanner'); ?>
    <script src="<?= $assets_url . '/js/jquery.min.js' ?>"></script>
    <script src="https://unpkg.com/html5-qrcode"></script>
        
    <style>
        body {
            text-align: center;
            margin-top: 50px;
        }

        #scanBtn {
            font-size: 32px;
            padding: 25px 25px;
            border-radius: 12px;
            min-width: 250px;
            background-color: #88A0BF;
            color: white;
            border: none;
            cursor: pointer;
        }
        
        /* Make button full width and larger on mobile */
        @media (max-width: 768px) {
            #scanBtn {
                font-size: 40px;
                padding: 25px 25px;
                width: 50%;
            }
        }
        
        .scan-img {
            width: 200px;
            height: auto;
            display: block;
            margin: 0 auto;
            border-radius: 4px;
        }

    </style>
</head>

<body>
    
    <div style="width: 300px; margin: 0 auto;">
  <div id="reader"></div>
</div>
    <button type="button" class="btn btn-info" id="scanBtn"><img src="<?= htmlspecialchars($assets_url . '/img/scan.jpg') ?>" alt="Scan Image" class="scan-img" /></button>
    
    <script>
       
            $("#scanBtn").click(function(event) {
                event.preventDefault();
                startScanner();
            });

           function startScanner() {
                const html5QrCode = new Html5Qrcode("reader");
            
                const config = { fps: 10, qrbox: 250 };
            
                html5QrCode.start(
                    { facingMode: "environment" }, // rear camera
                    config,
                    (decodedText, decodedResult) => {
                        console.log("Scanned Code:", decodedText);
                        alert("Scanned: " + decodedText);
                        html5QrCode.stop(); // stop camera
                        fetchApiData(decodedText);
                    },
                    (errorMessage) => {
                        // console.log(`Scan error: ${errorMessage}`);
                    }
                ).catch(err => {
                    console.error("Camera start failed:", err);
                    alert("Camera failed to start");
                });
            }
            
            function fetchApiData(code) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo base_url('Scanner/fetchDataFromAPI'); ?>",
                    data: { tknNo: code },
                    success: function (data) {
                        console.log("Response:", data);
            
                        // Ensure JSON string (in case it's already a string)
                        const jsonString = (typeof data === "string") ? data : JSON.stringify(data);
            
                        // Create a hidden form to submit POST
                        const form = document.createElement("form");
                        form.method = "POST";
                        form.action = "<?= base_url('Scanner/displayCargo') ?>";
            
                        const input = document.createElement("input");
                        input.type = "hidden";
                        input.name = "cargoData";
                        input.value = jsonString;
            
                        form.appendChild(input);
                        document.body.appendChild(form);
                        form.submit();
                    },

                    error: function () {
                        alert("Failed to contact server.");
                    }
                });
            }
      
    </script>
    
</body>

</html>